#ifndef _YMOD_IMAPCLIENT_COMMAND_EXAMINE_H_
#define _YMOD_IMAPCLIENT_COMMAND_EXAMINE_H_

#include "command.hpp"
#include <grammar/examine_grammar.hpp>

namespace ymod_imap_client {

template <>
std::shared_ptr<ImapMailboxResult> makeParsedResult(grammar::ParseResultPtr parsed)
{
    MailboxInfo parsedResult;
    parsedResult.exists_ = parsed->mailboxInfoResponse.exists;
    parsedResult.nextuid_ = parsed->mailboxInfoResponse.uidnext;
    parsedResult.uidvalidity_ = parsed->mailboxInfoResponse.uidvalidity;
    return std::make_shared<ImapMailboxResult>(std::move(parsedResult));
}

template <>
std::shared_ptr<ImapStatus> makeParsedResult(grammar::ParseResultPtr parsed)
{
    MailboxInfo res;
    res.exists_ = parsed->statusResponse.mailboxInfoResponse.exists;
    res.uidvalidity_ = parsed->statusResponse.mailboxInfoResponse.uidvalidity;
    res.nextuid_ = parsed->statusResponse.mailboxInfoResponse.uidnext;
    res.recent_ = parsed->statusResponse.mailboxInfoResponse.recent;
    res.unseen_ = parsed->statusResponse.mailboxInfoResponse.unseen;

    return std::make_shared<ImapStatus>(std::move(res));
}

class CommandExamine : public CommandBase<ImapMailboxResult>
{
public:
    CommandExamine(const std::string& tag, const Utf8MailboxName& mailbox)
        : CommandBase(tag, "EXAMINE", imap_quote(Utf7ImapMailboxName(mailbox).asString()))
    {
    }

    virtual grammar::ParseResultPtr parseResponse(std::shared_ptr<std::string> response)
    {
        grammar::ParseResult res;
        bool parseOk = boost::spirit::qi::parse(
            response->begin(),
            response->end(),
            grammar::ExamineResponseGrammar<std::string::iterator>(),
            res);
        if (!parseOk) return nullptr;
        return std::make_shared<grammar::ParseResult>(std::move(res));
    }
};

class CommandSelect : public CommandBase<ImapResult>
{
public:
    CommandSelect(const std::string& tag, const Utf8MailboxName& mailbox)
        : CommandBase(tag, "SELECT", imap_quote(Utf7ImapMailboxName(mailbox).asString()))
    {
    }
};

class CommandStatus : public CommandBase<ImapStatus>
{
public:
    CommandStatus(const std::string& tag, const Utf8MailboxName& mailbox, const std::string& fields)
        : CommandBase(
              tag,
              "STATUS",
              imap_quote(Utf7ImapMailboxName(mailbox).asString()) + " (" + fields + ")")
    {
    }
};

} // namespace ymod_imap_client

#endif // _YMOD_IMAPCLIENT_COMMAND_EXAMINE_H_
