#ifndef _YMOD_IMAPCLIENT_COMMAND_FETCH_H_
#define _YMOD_IMAPCLIENT_COMMAND_FETCH_H_

#include "command.hpp"
#include <grammar/fetch_grammar.hpp>

namespace ymod_imap_client {

template <>
std::shared_ptr<MessageSet> makeParsedResult(grammar::ParseResultPtr parsed)
{
    ImapMessageVector messages;

    for (auto& fetchItem : parsed->fetchResponses)
    {
        ImapMessage newMsg;
        newMsg.num = fetchItem.num;
        newMsg.uid = fetchItem.uid;
        newMsg.flags = fetchItem.flags;
        newMsg.size = fetchItem.size;
        newMsg.internaldate = fetchItem.internaldate_to_time();
        newMsg.gmailLabels = fetchItem.xgmlabels;
        if (fetchItem.body)
        {
            newMsg.body = std::move(*fetchItem.body);
        }

        messages.push_back(newMsg);
    }
    return std::make_shared<MessageSet>(std::move(messages));
}

class CommandFetchBase : public CommandBase<MessageSet>
{
public:
    CommandFetchBase(const std::string& tag, const std::string& command, const std::string& args)
        : CommandBase(tag, command, args)
    {
    }

    virtual grammar::ParseResultPtr parseResponse(std::shared_ptr<std::string> response)
    {
        std::vector<FetchResponse> fetchResponses;
        grammar::FetchResponseGrammar<std::string::iterator> fetchGrammar(
            [&](const FetchResponse& fetchResponse) { fetchResponses.push_back(fetchResponse); });

        grammar::ParseResult res;
        bool parseOk =
            boost::spirit::qi::parse(response->begin(), response->end(), fetchGrammar, res);
        if (!parseOk) return nullptr;

        res.fetchResponses = std::move(fetchResponses);
        return std::make_shared<grammar::ParseResult>(std::move(res));
    }
};

class CommandFetch : public CommandFetchBase
{
public:
    CommandFetch(const std::string& tag, const std::string& seqset, const std::string& args)
        : CommandFetchBase(tag, "FETCH", seqset + " (" + args + ")")
    {
    }
};

class CommandUidFetch : public CommandFetchBase
{
public:
    CommandUidFetch(const std::string& tag, const std::string& seqset, const std::string& args)
        : CommandFetchBase(tag, "UID FETCH", seqset + " (" + args + ")")
    {
    }
};

} // namespace ymod_imap_client

#endif // _YMOD_IMAPCLIENT_COMMAND_FETCH_H_
