#ifndef _YMOD_IMAPCLIENT_COMMAND_LOGIN_H_
#define _YMOD_IMAPCLIENT_COMMAND_LOGIN_H_

#include "command.hpp"

namespace ymod_imap_client {

//-----------------------------------------------------------------------------
// Logging in

class CommandLogin : public CommandBase<ImapResult>
{
public:
    CommandLogin(const std::string& tag, const std::string& user, const std::string& pass)
        : CommandBase(tag, "LOGIN", user + " " + imap_quote(pass)), user(user)
    {
    }

    virtual string debugDump() const
    {
        return tag() + " " + name() + " " + user + " <password>";
    }

protected:
    std::string user;
};

} // namespace ymod_imap_client

#endif // _YMOD_IMAPCLIENT_COMMAND_LOGIN_H_
