#pragma once

#include <util/imap_filter.hpp>

#include <boost/variant.hpp>
#include <exception>
#include <string>

namespace ymod_imap_client {

struct Continue
{
};

struct StartTls
{
};

struct SendData
{
    std::string data;
    ImapFilterState filterState;
};

struct ReadData
{
    ImapFilterState filterState;
    std::size_t atleast;
};

struct CommandFinished
{
};

struct CommandError
{
    std::exception_ptr e;
};

using CommandState =
    boost::variant<Continue, StartTls, SendData, ReadData, CommandFinished, CommandError>;

}
