#ifndef _YMOD_IMAP_CLIENT_GRAMMAR_EXAMINE_RESPONSE_H_
#define _YMOD_IMAP_CLIENT_GRAMMAR_EXAMINE_RESPONSE_H_

#include "imap_base.hpp"

#include <boost/variant.hpp>
#include <boost/optional.hpp>
#include <boost/algorithm/string.hpp>

namespace ymod_imap_client { namespace grammar {

template <class Iterator>
struct ExamineResponseGrammar
    : public ImapBasicGrammar<Iterator>
    , public bsq::grammar<Iterator, ParseResult()>
{
    ExamineResponseGrammar() : ExamineResponseGrammar::base_type(this->fullResponse)
    {
        this->untaggedResponses =
            *("* " >> !this->resp_cond_bye >>
              (this->mailbox_data(bph::bind(&ParseResult::mailboxInfoResponse, _val)) |
               this->resp_cond_state(bph::bind(&ParseResult::mailboxInfoResponse, _val)) |
               omit[this->reason]) >>
              this->imapEol);

        mailbox_data = ("FLAGS " >> flag_list) |
            (uint_ >> " EXISTS")[bph::bind(&MailboxInfoResponse::exists, _r1) = bsq::_1] |
            (uint_ >> " RECENT")[bph::bind(&MailboxInfoResponse::recent, _r1) = bsq::_1];

        resp_cond_state = (lit("OK ") | "NO " | "BAD ") >> resp_text(_r1);

        resp_text = -("[" >> resp_text_code(_r1) >> "]") >> *(char_ - bsq::eol);

        auto refUidnext = bph::bind(&MailboxInfoResponse::uidnext, _r1);
        auto refUidvalidity = bph::bind(&MailboxInfoResponse::uidvalidity, _r1);
        auto refUnseen = bph::bind(&MailboxInfoResponse::unseen, _r1);
        resp_text_code = ("UIDNEXT " >> uint_)[refUidnext = bsq::_1] |
            ("UIDVALIDITY " >> uint_)[refUidvalidity = bsq::_1] |
            ("UNSEEN " >> uint_)[refUnseen = bsq::_1] | +(char_ - "]");

        flag_list = "(" >> -(flag >> *(" " >> flag)) >> ")";

        flag = no_case
                   [lit("\\Answered") | "\\Flagged" | "\\Deleted" | "\\Seen" | "\\Draft" |
                    "\\" >> +this->ATOM_CHAR] |
            +this->ATOM_CHAR;
    }

    boost::spirit::qi::rule<Iterator, void(MailboxInfoResponse&)> response_data;
    boost::spirit::qi::rule<Iterator, void(MailboxInfoResponse&)> resp_cond_state;
    boost::spirit::qi::rule<Iterator, void(MailboxInfoResponse&)> resp_text;
    boost::spirit::qi::rule<Iterator, void(MailboxInfoResponse&)> resp_text_code;
    boost::spirit::qi::rule<Iterator, void(MailboxInfoResponse&)> mailbox_data;

    boost::spirit::qi::rule<Iterator> flag_list;
    boost::spirit::qi::rule<Iterator> flag;
};

} // namespace grammar
} // namespace ymod_imap_client

#endif // _YMOD_IMAP_CLIENT_GRAMMAR_EXAMINE_RESPONSE_H_
