#ifndef _YMOD_IMAP_CLIENT_GRAMMAR_LIST_RESPONSE_H_
#define _YMOD_IMAP_CLIENT_GRAMMAR_LIST_RESPONSE_H_

#include "imap_base.hpp"

#include <boost/variant.hpp>
#include <boost/optional.hpp>
#include <boost/algorithm/string.hpp>

namespace ymod_imap_client { namespace grammar {

struct DelimTag;
struct FolderNameTag;
struct FolderFlagsTag;

using Delim = TypeWrap<char, DelimTag>;
using FolderName = TypeWrap<std::string, FolderNameTag>;
using FolderFlags = TypeWrap<uint32_t, FolderFlagsTag>;
using ListAttr = boost::variant<Delim, FolderName, FolderFlags>;

template <class Iterator>
struct ListResponseFactory : public ListResponse
{
    using Type = ListResponseFactory<Iterator>;

    ListResponseFactory() = default;
    ListResponseFactory(const ListResponseFactory&) = default;
    ListResponseFactory(const ListResponse& resp) : ListResponse(resp)
    {
    }

    ListResponse produce() const
    {
        return static_cast<const ListResponse&>(*this);
    }
};

template <class Iterator>
struct ResponseFactory<Iterator, ListResponse>
{
    using Type = typename ListResponseFactory<Iterator>::Type;
};

template <class Iterator>
struct ListResponseGrammar
    : public ImapBasicGrammar<Iterator>
    , public bsq::grammar<Iterator, ParseResult()>
{
    using ParseHandler = ParseHandlerWrapper<Iterator, ListResponse>;
    using ParseCallback = typename ParseHandler::Callback;
    using ImapGrammar = ImapBasicGrammar<Iterator>;

    ListResponseGrammar(ParseCallback handler)
        : ListResponseGrammar::base_type(this->fullResponse), parseHandler(ParseHandler(handler))
    {
        this->untaggedResponses =
            *(("* " >> !this->resp_cond_bye >> (this->mailbox_data[parseHandler(bsq::_1)] |
                                                !this->list_prefix >> omit[this->reason]) >>
               this->imapEol)[parseHandler()]);

        mailbox_data = omit[list_prefix] >> mailbox_list;
        list_prefix = bsq::no_case[lit("LIST ")];

        auto valFlags = bph::bind(&ListResponse::flags, _val);
        auto valDelim = bph::bind(&ListResponse::delim, _val);
        auto valName = bph::bind(&ListResponse::name, _val);

        mailbox_list = "(" >> -(mbx_list_flags[valFlags = bsq::_1]) >> lit(") ") >>
            (('"' >> this->QUOTED_CHAR[valDelim = bsq::_1] >> '"') | lit("NIL")[valDelim = 0]) >>
            ' ' >> mailbox[valName = bsq::_1];

        mbx_list_flags =
            ((*(mbx_list_oflag(_val) >> ' ') >> mbx_list_sflag(_val) >>
              *(' ' >> mbx_list_oflag(_val))) |
             (mbx_list_oflag(_val) >> *(' ' >> mbx_list_oflag(_val))))[_val];

        mbx_list_oflag = no_case
                             [lit("\\Noinferiors")[_r1 |= ListResponse::ff_noinferiors] |
                              lit("\\Drafts")[_r1 |= ListResponse::ff_drafts] |
                              lit("\\Sent")[_r1 |= ListResponse::ff_sent] |
                              lit("\\Trash")[_r1 |= ListResponse::ff_trash] |
                              lit("\\Junk")[_r1 |= ListResponse::ff_spam] |
                              lit("\\Spam")[_r1 |= ListResponse::ff_spam] |
                              lit("\\All")[_r1 |= ListResponse::ff_all] |
                              lit("\\Important")[_r1 |= ListResponse::ff_important] |
                              lit("\\Flagged")[_r1 |= ListResponse::ff_starred] |
                              lit("\\HasNoChildren")[_r1 |= ListResponse::ff_hasnochildren]] |
            omit[flag_extension];

        mbx_list_sflag = no_case
            [lit("\\Noselect")[_r1 |= ListResponse::ff_noselect] |
             lit("\\Unmarked")[_r1 |= ListResponse::ff_unmarked] |
             lit("\\Marked")[_r1 |= ListResponse::ff_marked]];

        flag_extension = !mbx_list_sflag(_val) >> omit['\\' >> +this->ATOM_CHAR];

        mailbox = ImapGrammar::astring_;
    }

    bsq::rule<Iterator> response;
    bsq::rule<Iterator, ListResponse()> response_data;
    bsq::rule<Iterator, ListResponse()> mailbox_data;
    bsq::rule<Iterator, std::string()> list_prefix;
    bsq::rule<Iterator, ListResponse()> mailbox_list;
    bsq::rule<Iterator, std::string()> mailbox;
    bsq::rule<Iterator, uint32_t()> mbx_list_flags;
    bsq::rule<Iterator, void(uint32_t&)> mbx_list_oflag;
    bsq::rule<Iterator, void(uint32_t&)> mbx_list_sflag;
    bsq::rule<Iterator, uint32_t()> flag_extension;
    boost::phoenix::function<ParseHandler> parseHandler;
};

} // namespace grammar
} // namespace ymod_imap_client

#endif // _YMOD_IMAP_CLIENT_GRAMMAR_LIST_RESPONSE_H_
