#ifndef _YMOD_IMAPCLIENT_IMAP_CLIENT_IMPL_H_
#define _YMOD_IMAPCLIENT_IMAP_CLIENT_IMPL_H_

#include "client_session.h"
#include <ymod_imapclient/imap_client.h>

namespace ymod_imap_client {

class ImapClientImpl : public ImapClient
{
public:
    ImapClientImpl(
        ClientSessionPtr session,
        yplatform::task_context_ptr context,
        ImapIdInfoPtr defaultIdInfo)
        : session(session), context(context), defaultIdInfo(defaultIdInfo)
    {
    }

    virtual ~ImapClientImpl();

    FutureConnectResult connect(const string& server, unsigned short port, bool ssl) override;

    FutureConnectResult connect(
        const string& server,
        const string& serverLoggingAlias,
        unsigned short port,
        bool ssl) override;

    FutureCapability capability() override;

    FutureIdResult id(const string& idData) override;

    FutureImapResult startTls() override;

    FutureImapResult login(const string& user, const string& password) override;

    FutureImapResult loginOauth(const string& user, const string& accessToken, OauthLoginType type)
        override;

    FutureImapResult authPlain(const string& user, const string& password) override;

    FutureImapList list(const std::string& refName, const std::string& mailbox) override;

    FutureImapStatus status(const Utf8MailboxName& mailbox, const std::string& fields) override;

    FutureImapMailbox examine(const Utf8MailboxName& mailbox) override;

    FutureImapResult select(const Utf8MailboxName& mailbox) override;

    FutureMessageSet fetch(const string& seqset, const FetchArgs& args) override;

    FutureMessageSet uidFetch(const string& seqset, const FetchArgs& args) override;

    FutureImapResult noop() override;

    FutureImapResult logout() override;

    FutureImapResult createMailbox(const Utf8MailboxName& mailbox) override;

    FutureImapResult deleteMailbox(const Utf8MailboxName& mailbox) override;

    FutureImapResult renameMailbox(
        const Utf8MailboxName& oldMailbox,
        const Utf8MailboxName& newMailbox) override;

    FutureImapResult expunge() override;

    FutureMessageSet uidStore(
        const std::string& seqset,
        const std::string& storeType,
        const std::string& args) override;

    FutureCopyuidResult uidMove(const std::string& seqset, const Utf8MailboxName& newMailbox)
        override;

    FutureCopyuidResult uidCopy(const std::string& seqset, const Utf8MailboxName& newMailbox)
        override;

    FutureAppenduidResult append(
        std::string&& body,
        const Utf8MailboxName& mailbox,
        const std::string& flags,
        const std::string& date) override;

    string serverIp() const override;

    void setVerbose(const VerbositySettings& verbose) override;

    Statistics getStats() override;

    void setCommandTimeout(const yplatform::time_traits::duration& timeout) override;

protected:
    ClientSessionPtr session;
    yplatform::task_context_ptr context;
    ImapIdInfoPtr defaultIdInfo;
};

} // namespace ymod_imap_client

#endif // _YMOD_IMAPCLIENT_IMAP_CLIENT_H_
