#ifndef _YMOD_IMAPCLIENT_IMAP_UTILS_H_
#define _YMOD_IMAPCLIENT_IMAP_UTILS_H_

#include <boost/range.hpp>
#include <algorithm>

namespace {

template <class Iterator>
std::string imap_quote(Iterator beg, Iterator end)
{
    std::string res = "\"";
    while (beg != end)
    {
        auto v = *beg++;
        if (v == '\\') res += "\\\\";
        else if (v == '"')
            res += "\\\"";
        else
            res += v;
    }
    res += '"';
    return res;
}

inline std::string imap_quote(const std::string& str)
{
    return imap_quote(str.begin(), str.end());
}

template <class Iterator, int head = 1000, int tail = 1000>
struct trunced_responce
{
    trunced_responce(Iterator b, Iterator e) : beg(b), end(e)
    {
    }

    Iterator beg;
    Iterator end;
};

template <class Iterator, int head, int tail>
std::ostream& operator<<(std::ostream& os, const trunced_responce<Iterator, head, tail>& tr)
{
    if (tr.end - tr.beg <= head + tail)
    {
        os << boost::make_iterator_range(tr.beg, tr.end);
    }
    else
    {
        Iterator head_end = tr.beg + head;
        os << boost::make_iterator_range(tr.beg, head_end);
        os << "[..]";
        Iterator tail_beg = tr.end - tail;
        os << boost::make_iterator_range(tail_beg, tr.end);
    }
    return os;
}

template <class Iterator>
struct trunced_responce<Iterator> make_trunced_responce(Iterator beg, Iterator end)
{
    return trunced_responce<Iterator>(beg, end);
}

} // namespace

#endif // _YMOD_IMAPCLIENT_IMAP_UTILS_H_
