/**
 * @author: nordsturm
 * © Yandex LLC.
 */

#ifndef YMOD_LEASE_NODE_H
#define YMOD_LEASE_NODE_H

#include <string>
#include <yplatform/module.h>
#include <yplatform/find.h>
#include <boost/function.hpp>

#include <ymod_lease/types.h>
#include <ymod_lease/settings.h>

namespace ylease {

/** Lease node
 *
 * Provides start and stop acquire resource lease functions and allows to set
 * callbacks on win or lose resource.
 * Virtual methods usually are being overloaded in unit tests.
 */
class node : public yplatform::module
{
public:
    node(yplatform::reactor& reactor, const yplatform::ptree& ptree);
    node(boost::asio::io_service& io, const yplatform::ptree& ptree);
    node(yplatform::reactor& reactor, const settings&);
    node(boost::asio::io_service& io, const settings&);

    void reload(const settings&);
    void reload(const yplatform::ptree& ptree);
    void fini();

    // Shadows base class method.
    void logger(const yplatform::log::source&);

    void set_verbose_logging(bool verbose);

    virtual const node_id& node_id();
    virtual void bind(
        const std::string& resource_name,
        const busy_callback& busy_callback,
        const free_callback& free_callback);
    virtual void subscribe_peers_count(const peers_count_callback& callback);
    virtual void start_acquire_lease(const std::string& resource_name);
    virtual void start_read_only(const std::string& resource_name);
    virtual void update_acquire_value(const std::string& resource_name, const value& value);
    virtual void update_lease_time(const std::string& resource_name, const time_duration& time);
    virtual void stop_acquire_lease(const std::string& resource_name);
    virtual std::string address_from_id(const ylease::node_id&);

    virtual ~node()
    {
    }

protected:
    node()
    { /* do nothing, fake ctor for inheritance in tests */
    }

private:
    class impl;
    std::shared_ptr<impl> impl_;
};
}

namespace ymod_lease = ylease;

#endif
