#pragma once

#include <ymod_messenger/types.h>
#include <atomic>
#include <string>

namespace ylease {

struct settings
{
    std::string lease_log_id;
    std::string netch_module_name = "netch";
    ymod_messenger::message_type netch_base_type = 9000;
    unsigned acquire_lease_timeout = 1200; // msec
    unsigned max_lease_time = 5000;        // msec
    std::string tag;
    unsigned arbiters_count = 3; // to calc majority count
    bool verbose_logging = false;

    void parse_ptree(const yplatform::ptree& conf)
    {
        lease_log_id = conf.get("lease_log_id", lease_log_id);
        netch_module_name = conf.get("netch_module", netch_module_name);
        netch_base_type = conf.get("netch_message_base_type", netch_base_type);
        tag = conf.get("tag", tag);
        arbiters_count = conf.get("arbiters_count", arbiters_count);
        verbose_logging = conf.get("verbose_logging", verbose_logging);
        // Aliased.
        acquire_lease_timeout = conf.get("acquire-timeout", acquire_lease_timeout);
        acquire_lease_timeout = conf.get("acquire_timeout", acquire_lease_timeout);
        max_lease_time = conf.get("max-lease-time", max_lease_time);
        max_lease_time = conf.get("max_lease_time", max_lease_time);
    }
};

}