#pragma once

#include <yplatform/module.h>
#include <yplatform/time_traits.h>
#include <yplatform/util/weak_bind.h>

#include <string>
#include <boost/function.hpp>
#include <boost/system/error_code.hpp>
#include <mutex>

namespace ylease {

using ballot_t = int64_t;
using node_id = std::string;
using value = std::string;

using busy_callback = std::function<
    void(const std::string& resource_name, const node_id&, const ballot_t, const value&)>;
using free_callback = std::function<void(const std::string& resource_name)>;
using peers_count_callback = std::function<void(size_t)>;

using yplatform::shared_from;
using yplatform::weak_from;
using yplatform::weak_bind;

namespace time_traits = yplatform::time_traits;
using time_duration = time_traits::duration;
using time_point = time_traits::time_point;
using steady_timer = time_traits::timer;
using time_traits::clock;
using time_traits::duration_cast;
using time_traits::milliseconds;

using error_code = boost::system::error_code;

using std::mutex;
using scoped_lock = std::unique_lock<mutex>;
}
namespace ymod_lease = ylease;
