#pragma once

#include <yplatform/module.h>
#include <yplatform/module_registration.h>
#include <yplatform/util/uuid_generator.h>
#include <ymod_messenger/ymod_messenger.h>

#include "messages.h"
#include "network.h"
#include "types_priv.h"
#include "logger.h"

#include "lease_config.h"
#include "resource_server.h"
#include "time_millis.h"
#include "timers_queue.h"
#include "nodes_registry.h"
#include <atomic>

namespace ylease {

/** Arbiter.
 *
 * @todo add active pool for messages hadling
 */
class arbiter_impl : public yplatform::module
{
public:
    void init(const yplatform::ptree& xml);
    void reload(const yplatform::ptree& xml);
    void start();
    void fini();

private:
    typedef boost::shared_ptr<resource_server> resource_server_ptr;
    typedef std::map<string, resource_server_ptr> resource_servers;

    void subscribe_mcast_messages();

    void on_prepare_message(const netch_address& sender, prepare_msg message);
    void on_accept_message(const netch_address& sender, accept_msg message);

    void send_promise(const netch_address& to, const promise_msg& message);
    void send_reject(const netch_address& to, const reject_msg& message);
    void send_accepted(const netch_address& to, const accepted_msg& message);
    void send_nodes_count(const netch_address& to, const nodes_count_msg& message);

    resource_server_ptr get_resource_server(const string& resource_name);

    void on_accepted(const netch_address& sender, const accepted_msg& message);

private:
    mutex mux_;

    boost::shared_ptr<netch> netch_;
    std::unique_ptr<message_types> netch_codes_;

    bool stop_;

    string arbiter_id_;

    timers::queue_ptr timers_queue_;

    resource_servers resource_servers_;

    std::shared_ptr<nodes_registry> nodes_registry_;
    time_duration node_inactive_timeout_;

    yplatform::util::string_uuid_generator uuids_generator_;
    std::atomic<bool> verbose_logging_;
    yplatform_log_wrapper yplatform_log_wrapper_;
};

}
