#include "callbacks_repository.h"
#include "messages.h"

using namespace ylease;

void lease_callbacks_repository::add(
    const string& resource_name,
    const busy_callback& busy_callback,
    const free_callback& free_callback)
{
    scoped_lock lock(mux_);
    map_[resource_name].busy_callbacks.push_back(busy_callback);
    map_[resource_name].free_callbacks.push_back(free_callback);
}

void lease_callbacks_repository::call_busy_callbacks(
    const string& resource_name,
    const ballot_t ballot,
    const lease& lease)
{
    scoped_lock lock(mux_);
    resource_callbacks& callbacks = map_[resource_name];
    // nothing to do if lease extended
    if (callbacks.lease.node == lease.node && callbacks.lease.value == lease.value)
    {
        return;
    }
    callbacks.lease = lease;
    // make a copy
    std::vector<busy_callback> callbacks_copy = callbacks.busy_callbacks;
    // and unlock
    lock.unlock();

    for (const busy_callback& cb : callbacks_copy)
    {
        cb(resource_name, lease.node, ballot, lease.value);
    }
}

void lease_callbacks_repository::call_free_callbacks(const string& resource_name)
{
    scoped_lock lock(mux_);
    resource_callbacks& callbacks = map_[resource_name];
    // nothing to do if was not winner
    if (callbacks.lease.node == "")
    {
        return;
    }
    callbacks.lease.reset();
    // make copy
    std::vector<free_callback> callbacks_copy = callbacks.free_callbacks;
    // and unlock
    lock.unlock();
    for (const free_callback& cb : callbacks_copy)
    {
        cb(resource_name);
    }
}
