/**
 * @file:   callbacks_repository.h
 * @author: nordsturm
 * © Yandex LLC.
 */

#ifndef YMOD_LEASE_CALLBACKS_REPOSITORY_H
#define YMOD_LEASE_CALLBACKS_REPOSITORY_H

#include <ymod_lease/node.h>
#include "types_priv.h"

namespace ylease {

/**
 * Lease callbacks (win and lose) repository
 *
 * calls win and
 */
class lease_callbacks_repository
{
public:
    /// put callbacks
    void add(
        const string& resource_name,
        const busy_callback& busy_callback,
        const free_callback& fose_callback);

    /// call busy callbacks (does nothing if extend)
    void call_busy_callbacks(
        const string& resource_name,
        const ballot_t ballot,
        const lease& lease);

    /// call free callbacks
    void call_free_callbacks(const string& resource_name);

private:
    mutex mux_;

    struct resource_callbacks
    {
        lease lease;
        std::vector<busy_callback> busy_callbacks;
        std::vector<free_callback> free_callbacks;
    };

    std::map<string, resource_callbacks> map_;
};

}

#endif
