#pragma once

#include <boost/function.hpp>
#include "types_priv.h"
#include <string>
#include <sstream>
#include <atomic>

namespace ylease {

typedef boost::function<void(const std::string&)> log_function_t;

class logger_t : public boost::noncopyable
{
public:
    logger_t(log_function_t& f) : func(f)
    {
    }
    ~logger_t()
    {
        func(ss.str());
    }
    template <typename T>
    logger_t& operator<<(T const& t)
    {
        ss << t;
        return *this;
    }

private:
    log_function_t& func;
    std::stringstream ss;
};

struct yplatform_log_wrapper : yplatform::log::contains_logger
{
public:
    yplatform_log_wrapper()
    {
        enabled_ = boost::make_shared<std::atomic<bool>>(true);
    }

    void operator()(const string& s)
    {
        if (*enabled_)
        {
            YLOG_L(info) << s;
        }
    }

    void set_enabled(bool value)
    {
        *enabled_ = value;
    }

private:
    boost::shared_ptr<std::atomic<bool>> enabled_;
};

#define L_STREAM(log_func) logger_t(log_func)

}
