#ifndef YMOD_LEASE_MESSAGES_H_
#define YMOD_LEASE_MESSAGES_H_

#include <vector>
#include <inttypes.h>

#include "lease_config.h"
#include "types_priv.h"
#include <msgpack.hpp>

namespace ylease {

/*
 * P1
 */

struct prepare_msg
{
    string resource_name;
    ballot_t ballot;
    node_id node;
    string tag;
    time_millis vote_interval = 0;

    MSGPACK_DEFINE(resource_name, ballot, node, tag, vote_interval);

    prepare_msg()
    {
    }

    prepare_msg(const string& _resource_name, ballot_t _ballot)
        : resource_name(_resource_name), ballot(_ballot)
    {
    }
};

struct promise_msg
{
    string arbiter_id;
    string resource_name;
    ballot_t ballot;
    ballot_t accepted_ballot;
    lease lease;

    bool is_busy() const
    {
        return accepted_ballot != -1;
    }

    MSGPACK_DEFINE(arbiter_id, resource_name, ballot, accepted_ballot, lease);

    promise_msg(
        const string& _arbiter_id = "-1",
        const string& _resource_name = "",
        ballot_t _ballot = -1)
        : arbiter_id(_arbiter_id)
        , resource_name(_resource_name)
        , ballot(_ballot)
        , accepted_ballot(-1)
    {
    }

    promise_msg(
        const string& _arbiter_id,
        const string& _resource_name,
        ballot_t _ballot,
        ballot_t _accepted_ballot,
        const ylease::lease& _lease)
        : arbiter_id(_arbiter_id)
        , resource_name(_resource_name)
        , ballot(_ballot)
        , accepted_ballot(_accepted_ballot)
        , lease(_lease)
    {
    }
};

struct reject_msg
{
    string arbiter_id;
    string resource_name;
    ballot_t ballot;
    ballot_t highest_promised;

    MSGPACK_DEFINE(arbiter_id, resource_name, ballot, highest_promised);

    reject_msg(
        const string& _arbiter_id = "-1",
        const string& _resource_name = "",
        ballot_t _ballot = -1,
        ballot_t _highest_promised = -1)
        : arbiter_id(_arbiter_id)
        , resource_name(_resource_name)
        , ballot(_ballot)
        , highest_promised(_highest_promised)
    {
    }
};

/*
 * P2
 */

struct accept_msg
{
    string resource_name;
    ballot_t ballot;
    lease lease;

    MSGPACK_DEFINE(resource_name, ballot, lease);

    accept_msg() : ballot(-1)
    {
    }

    accept_msg(const string& _resource_name, ballot_t _ballot, const ylease::lease& _lease)
        : resource_name(_resource_name), ballot(_ballot), lease(_lease)
    {
    }
};

struct accepted_msg
{
    string arbiter_id;
    string resource_name;
    ballot_t ballot;
    lease lease;

    MSGPACK_DEFINE(arbiter_id, resource_name, ballot, lease);

    accepted_msg() : arbiter_id("-1"), ballot(-1)
    {
    }

    accepted_msg(
        const string& _arbiter_id,
        const string& _resource_name,
        ballot_t _ballot,
        const ylease::lease& _lease)
        : arbiter_id(_arbiter_id), resource_name(_resource_name), ballot(_ballot), lease(_lease)
    {
    }
};

struct nodes_count_msg
{
    string tag;
    size_t count;

    MSGPACK_DEFINE(tag, count);
};

}

#endif /* _LIBPAXOS_PRIV_H_ */
