#pragma once

#include "types_priv.h"
#include <yplatform/util/safe_call.h>
#include <boost/asio/io_service.hpp>
#include <boost/asio/strand.hpp>
#include <unordered_map>
#include <vector>

namespace ylease {

using address_list = std::vector<string>;

/** nodes_registry.
 *
 * Stores actual lists of nodes by tag and notifies when list changed.
 */
class nodes_registry : public std::enable_shared_from_this<nodes_registry>
{
public:
    using update_callback = std::function<void(const string&, const address_list&)>;

    nodes_registry(boost::asio::io_service& io, const update_callback& list_update_callback);

    void insert(
        const string& address,
        const node_id& id,
        const string& tag,
        const time_duration& inactive_timeout);

private:
    struct node
    {
        node(const string& address, boost::asio::io_service& io);

        bool expired() const;

        string address;
        steady_timer timer;
    };

    using id_to_node_map = std::unordered_map<string, node>;

    void cleanup(const node_id& id, const string& tag);

    address_list make_address_list(const id_to_node_map& node_list);

    boost::asio::io_service::strand strand_;
    std::unordered_map<string, id_to_node_map> nodes_by_tag_;
    update_callback list_update_callback_;
};

}
