#include "peers_count_accumulator.h"

namespace ylease {

bool peers_count_accumulator::add(const netch_address& source, size_t source_value)
{
    value_by_arbiter_[source] = source_value;
    auto new_value = calc_value();
    bool changed = new_value != value_;
    value_ = new_value;
    return changed;
}

size_t peers_count_accumulator::value() const
{
    return value_;
}

size_t peers_count_accumulator::calc_value() const
{
    if (value_by_arbiter_.empty()) return 0;

    std::vector<std::size_t> values;
    values.reserve(value_by_arbiter_.size());
    for (auto& counts : value_by_arbiter_)
    {
        values.push_back(counts.second);
    }

    std::sort(values.begin(), values.end());
    std::size_t position = values.size() / 2;
    return (values.size() % 2 == 1) ? values[position] :
                                      (values[position] + values[position - 1]) / 2;
}

}