#pragma once

#include "network.h"
#include "types_priv.h"
#include <unordered_map>

namespace ylease {

/** peers_count_accumulator.
 *
 * Stores intermediate counters received from arbiters
 * and calculates median peers count.
 */
class peers_count_accumulator
{
public:
    // returns true when accumulated value is changed
    bool add(const netch_address& source, size_t source_value);

    size_t value() const;

private:
    size_t calc_value() const;

    std::unordered_map<netch_address, size_t> value_by_arbiter_;
    size_t value_ = 0;
};

}
