/**
 * @file:   types.h
 * @author: nordsturm
 * © Yandex LLC.
 */

#ifndef YMOD_LEASE_TYPES_PRIV_H
#define YMOD_LEASE_TYPES_PRIV_H

#include "time_millis.h"

#include <boost/shared_ptr.hpp>
#include <boost/function.hpp>
#include <boost/bind.hpp>
#include <boost/uuid/uuid_io.hpp>

#include <yplatform/time_traits.h>
#include <ymod_lease/types.h>

#include <msgpack.hpp>

namespace ylease {

using std::string;

using std::auto_ptr;
using boost::shared_ptr;

#define NODE_LOG(sev) YLOG_L(sev)
#define ARBITER_LOG(sev) YLOG_L(sev)

#define NODE_RESLOG(sev, res) NODE_LOG(sev) << "<" << (res) << "> "
#define ARBITER_RESLOG(sev, res) ARBITER_LOG(sev) << "<" << (res) << "> "

struct lease
{
    node_id node;
    uint64_t duration;
    value value;
    ballot_t ballot;

    MSGPACK_DEFINE(node, duration, value, ballot);

    lease() : node(), duration(0), ballot(-1)
    {
    }

    lease(node_id _node, uint64_t _duration, ylease::value const& _value, ballot_t _ballot = -1)
        : node(_node), duration(_duration), value(_value), ballot(_ballot)
    {
    }

    void reset()
    {
        node = "";
        value = "";
        ballot = -1;
    }
};

}

#endif
