#pragma once

#include <pgg/service/uid_resolver.h>
#include <macs_pg/service/service.h>
#include <macs_pg/service/shard.h>
#include <sharpei_client/sharpei_client.h>

#include <yplatform/module.h>
#include <yplatform/reactor.h>
#include <yplatform/task_context.h>

namespace ymod_macs {

using macs_service_ptr = macs::ServicePtr;
using macs_shard_ptr = macs::ShardPtr;
using uid_resolver_factory_ptr = pgg::UidResolverFactoryPtr;

using shard = sharpei::client::Shard;
using shard_id = shard::Id;
using id_shard_map = sharpei::client::MapShard;

using shard_cb = std::function<void(mail_errors::error_code, shard)>;
using shard_id_cb = std::function<void(mail_errors::error_code, shard_id)>;
using shards_cb = std::function<void(mail_errors::error_code, const id_shard_map&)>;

class module : public yplatform::module
{
public:
    module(yplatform::reactor& reactor, const yplatform::ptree& conf);

    macs_service_ptr get_service(
        yplatform::task_context_ptr context,
        const std::string& uid,
        bool use_replica = true,
        uid_resolver_factory_ptr factory = {});
    macs_shard_ptr get_shard(const shard_id& shard_id, bool use_replica = true);

    void get_shards(const shards_cb& cb);
    void get_shard_by_id(const shard_id&, const shard_cb&);
    void get_user_shard_id(
        yplatform::task_context_ptr context,
        const std::string& uid,
        shard_id_cb);

    void logger(const yplatform::log::source& logger); // shadows base class method

    yplatform::ptree get_stats() const override;

private:
    class impl;
    std::shared_ptr<impl> impl_;
};

}
