#pragma once

#include <macs_pg/macs_pg.h>

#include <yplatform/log.h>

namespace ymod_macs {

class macs_logger
    : public macs::pg::logging::Log
    , public yplatform::log::contains_logger
{
public:
    macs_logger(
        const yplatform::log::source& source,
        const std::string& uid = "",
        yplatform::task_context_ptr context = {})
        : yplatform::log::contains_logger(source), context_(context), uid_(uid)
    {
        std::string new_prefix;
        if (!uid_.empty())
        {
            new_prefix = uid_ + " ";
        }

        if (context_)
        {
            new_prefix += context_->uniq_id();
        }

        logger().set_log_prefix(logger().get_log_prefix() + new_prefix);
    }

    virtual void warning(
        const macs::pg::logging::Method& method,
        const macs::pg::logging::Message& message)
    {
        YLOG_L(error) << "macs warning from " << method << ": "
                      << boost::replace_all_copy(message, "\n", "\\n");
    }

    virtual void error(
        const macs::pg::logging::Method& method,
        const macs::pg::logging::Message& message)
    {
        YLOG_L(error) << "macs error from " << method << ": "
                      << boost::replace_all_copy(message, "\n", "\\n");
    }

    virtual void notice(
        const macs::pg::logging::Method& method,
        const macs::pg::logging::Message& message)
    {
        YLOG_L(error) << "macs notice from " << method << ": "
                      << boost::replace_all_copy(message, "\n", "\\n");
    }

    virtual void debug(
        const macs::pg::logging::Method& method,
        const macs::pg::logging::Message& message)
    {
        YLOG_L(debug) << "macs debug from " << method << ": "
                      << boost::replace_all_copy(message, "\n", "\\n");
    }

private:
    yplatform::task_context_ptr context_;
    std::string uid_;
};

}
