#include <ymod_macs/module.h>
#include "module_impl.h"

namespace ymod_macs {

module::module(yplatform::reactor& reactor, const yplatform::ptree& conf)
    : impl_(std::make_shared<module::impl>(reactor, conf))
{
    impl_->logger(*reactor.io());
}

macs_service_ptr module::get_service(
    yplatform::task_context_ptr context,
    const std::string& uid,
    bool use_replica,
    uid_resolver_factory_ptr factory)
{
    return impl_->get_service(context, uid, use_replica, factory);
}

macs_shard_ptr module::get_shard(const shard_id& shard_id, bool use_replica)
{
    return impl_->get_shard(shard_id, use_replica);
}

void module::get_shards(const shards_cb& cb)
{
    impl_->get_shards(cb);
}

void module::get_shard_by_id(const shard_id& id, const shard_cb& cb)
{
    impl_->get_shard_by_id(id, cb);
}

void module::get_user_shard_id(
    yplatform::task_context_ptr context,
    const std::string& uid,
    shard_id_cb cb)
{
    impl_->get_user_shard_id(context, uid, cb);
}

void module::logger(const yplatform::log::source& logger)
{
    contains_logger::logger(logger);
    impl_->logger(logger);
}

yplatform::ptree module::get_stats() const
{
    return impl_->get_stats();
}

}

#include <yplatform/module_registration.h>
DEFINE_SERVICE_OBJECT(ymod_macs::module);
