#pragma once

#include <pgg/profiling.h>
#include <pa/async.h>

#include <yplatform/task_context.h>

namespace ymod_macs {

class macs_profiler : public pgg::profiling::Log
{
    using pa_profiler = pa::async_profiler;

public:
    macs_profiler(yplatform::task_context_ptr context = {}) : context_(context)
    {
    }

    void write(const std::string& operation, const std::string& info, pgg::Duration duration)
        const override
    {
        pa_profiler::add(
            pa::postgresql,
            context_ ? context_->uniq_id() : "no_context",
            info,
            operation,
            static_cast<uint32_t>(pgg::Milliseconds(duration).count()));
    }

private:
    yplatform::task_context_ptr context_;
};

}
