#pragma once

#include <user_journal/parameters/parameter_id.h>
#include <user_journal/logging.h>
#include <user_journal/profiling.h>
#include <user_journal/file_writer.h>
#include <user_journal/service.h>
#include <user_journal/service_factory.h>

#include <pa/async.h>

#include <mail/ymod_maildb/include/log.h>


namespace ymod_maildb {

struct UserJournalLog: public user_journal::logging::Log {
    UjLogger logger;

    UserJournalLog(UjLogger l)
        : logger(std::move(l))
    { }

    void warning(const std::string& uid, const std::string& method, const std::string& message, int code) override {
        LOGDOG_(logger, warning, log::where_name=method, log::message=message, log::uid=uid, log::code=code);
    }

    void error(const std::string& uid, const std::string& method, const std::string & message, int code) override {
        LOGDOG_(logger, error, log::where_name=method, log::message=message, log::uid=uid, log::code=code);
    }

    void notice(const std::string& uid, const std::string& method, const std::string& message) override {
        LOGDOG_(logger, notice, log::where_name=method, log::message=message, log::uid=uid);
    }

    void debug(const std::string& uid, const std::string& method, const std::string& message) override {
        LOGDOG_(logger, debug, log::where_name=method, log::message=message, log::uid=uid);
    }
};

struct ProfilerLog: public user_journal::profiling::Log {
    pa::async_profiler p;

    ProfilerLog() { }

    void write(const std::string& operation, const std::string& info,
               user_journal::profiling::Duration duration) override {
        p.add(pa::hbase, "user_journal", operation, info, static_cast<uint32_t>(duration.count()));
    }
};

}
