#pragma once

#include <logdog/format/tskv.h>
#include <logdog/attributes/mail_attributes.h>
#include <logdog/backend/yplatform_log.h>


namespace ymod_maildb {

namespace log {
LOGDOG_DEFINE_ATTRIBUTE(int, code)
using namespace ::logdog::attr;
constexpr static auto maildb_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-maildb-tskv-log"));
constexpr static auto uj_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-user-journal-tskv-log"));
}

auto getUjLogger(const std::string& logName) {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, logName);
    return ::logdog::make_log(log::uj_formatter, logger);
}

auto getModuleLogger(const std::string& logName) {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, logName);
    return ::logdog::make_log(log::maildb_formatter, logger);
}

using UjLogger = decltype(getUjLogger(""));
using ModuleLogger = decltype(getModuleLogger(""));

}
