#pragma once

#include <macs_pg/service/service.h>
#include <macs_pg/logging.h>
#include <pgg/factory.h>
#include <user_journal/service.h>
#include <mail/user_journal/helpers/geobase.h>
#include <mail/user_journal/helpers/uatraits.h>

#include <mail/ymod_maildb/include/params.h>

namespace ymod_maildb {

struct Module {
    virtual user_journal::ServicePtr userJournalService() const = 0;
    virtual user_journal::Uatraits uatraits() const = 0;
    virtual user_journal::Geobase geobase() const = 0;

    virtual macs::ServicePtr service(const ServiceParams& params,
                                     const UserJournalParams& uj,
                                     macs::pg::logging::v2::LogPtr macsPgLog,
                                     const pgg::QueryHandleStrategy& strategy) const = 0;

    user_journal::Journal journal(const ServiceParams& s,
                                  const UserJournalParams& uj) const;
};

using ModulePtr = std::shared_ptr<Module>;

}
