#pragma once

#include "types.h"

namespace ymod_mdb_sharder {

enum class error : int
{
    ok = 0,
    cannot_get_owner,
    not_owned,
    user_not_found,

    COUNT
};

inline const std::string& error_message(error err)
{
    static constexpr std::initializer_list<const char*> names = {
        "success", "can't get user owner", "not owned by any node", "user not found"
    };
    static_assert(
        names.size() == static_cast<size_t>(error::COUNT),
        "Error codes count doesn't correspond with error names count");
    static const std::vector<std::string> error_names(names.begin(), names.end());

    return error_names[static_cast<int>(err)];
}

}

namespace boost { namespace system {

template <>
struct is_error_code_enum<ymod_mdb_sharder::error>
{
    static const bool value = true;
};

}}

namespace ymod_mdb_sharder {

const boost::system::error_category& get_error_category();

inline error_code make_error_code(error e)
{
    return error_code(static_cast<int>(e), get_error_category());
}

}