#pragma once

#include "types.h"
#include <yplatform/module.h>

namespace ymod_mdb_sharder {

class shards_distributor : public yplatform::module
{
public:
    shards_distributor(boost::asio::io_service& io, const yplatform::ptree& conf);

    void subscribe(const shard_ids_cb& on_acquire_shards, const shard_ids_cb& on_release_shards);
    void get_owner(task_context_ptr context, const shard_id& shard, const node_info_cb& cb);
    const std::string& my_node_id() const;

    void get_acquired_shards(const shard_ids_cb& cb);
    // release_shards_for is not supported while working with buckets.
    void release_shards_for(const shard_ids& shards, const time_traits::duration& duration);

    void get_acquired_buckets_info(const buckets_info_cb& cb);
    void release_buckets_for(const bucket_ids& buckets, const time_traits::duration& duration);
    void add_bucket(const bucket_id& bucket, const shard_ids& shards);
    void del_bucket(const bucket_id& bucket);
    void add_shards_to_bucket(const bucket_id& bucket, const shard_ids& shards);
    void del_shards_from_bucket(const bucket_id& bucket, const shard_ids& shards);

    void start();
    void logger(const yplatform::log::source& source); // Shadows base class method.

private:
    struct impl;
    std::shared_ptr<impl> impl_;
};

}