#pragma once

#include <yplatform/task_context.h>
#include <yplatform/util/weak_bind.h>
#include <yplatform/time_traits.h>
#include <boost/system/error_code.hpp>
#include <functional>
#include <string>
#include <vector>
#include <memory>
#include <map>

namespace ymod_mdb_sharder {

namespace time_traits = yplatform::time_traits;
namespace ph = std::placeholders;

using error_code = boost::system::error_code;
using yplatform::task_context_ptr;
using yplatform::weak_bind;

using uid_t = uint64_t;
using shard_id = std::string;
using shard_ids = std::vector<shard_id>;
using bucket_id = std::string;
using bucket_ids = std::vector<std::string>;

struct node_info
{
    std::string id;
    std::string host;

    std::string to_string() const;
    static node_info from_string(const std::string&);
};

struct shard_user
{
    uid_t uid;
    bool is_here;
    bool is_deleted;
    std::time_t here_since_ts;
    std::time_t purge_ts;
};
using shard_users = std::vector<shard_user>;

using uids_cb = std::function<void(const std::vector<uid_t>&)>;
using shard_ids_cb = std::function<void(const shard_ids&)>;
using shard_id_with_uids_cb = std::function<void(const shard_id&, const std::vector<uid_t>&)>;
using shard_users_cb = std::function<void(error_code, const shard_users&)>;
using node_info_cb = std::function<void(error_code, const node_info&)>;
using buckets_info_cb = std::function<void(const std::map<bucket_id, shard_ids>&)>;
using get_all_users_method = std::function<void(const shard_id&, const shard_users_cb&)>;
using get_changed_users_method = std::function<void(
    const shard_id&,
    std::time_t last_moved_ts,
    std::time_t last_deleted_ts,
    const shard_users_cb&)>;

}