#pragma once

#include "types.h"
#include <yplatform/module.h>
#include <yplatform/reactor.h>

namespace ymod_mdb_sharder {

class users_distributor : public yplatform::module
{
public:
    users_distributor(boost::asio::io_service& io, const yplatform::ptree& conf);

    void subscribe(
        const shard_id_with_uids_cb& on_acquire_users,
        const shard_id_with_uids_cb& on_release_users);
    void get_owner(task_context_ptr context, uid_t uid, const node_info_cb& cb);
    void set_polling_methods(
        const get_all_users_method& get_all_users,
        const get_changed_users_method& get_changed_users);
    const std::string& my_node_id() const;

    void start();
    void fini();
    void logger(const yplatform::log::source& source); // Shadows base class method.

private:
    struct impl;
    std::shared_ptr<impl> impl_;
};

}