#include "json.h"
#include <json/reader.h>
#include <json/writer.h>

namespace ymod_mdb_sharder::json {

std::string to_string(const value& value)
{
    std::string result;
    if (value.isConvertibleTo(Json::ValueType::stringValue))
    {
        result = value.asString();
    }
    else
    {
        Json::FastWriter writer;
        result = writer.write(value);
        // Unfortunately, it writes ending \n.
        result.resize(result.size() - 1);
    }
    return result;
}

value from_string(const std::string& json)
{
    Json::Reader reader;
    value result;

    bool parse_ok = reader.parse(json, result);
    if (!parse_ok)
    {
        throw std::runtime_error("invalid json");
    }
    return result;
}

}