#include <ymod_mdb_sharder/types.h>
#include "json.h"

namespace ymod_mdb_sharder {

std::string node_info::to_string() const
{
    json::value json;
    json["id"] = id;
    json["host"] = host;
    return json::to_string(json);
}

node_info node_info::from_string(const std::string& json_value)
{
    auto json = json::from_string(json_value);
    node_info ret;
    ret.host = json["host"].asString();
    ret.id = json["id"].asString();
    return ret;
}

}