#include <ymod_mdb_sharder/users_distributor.h>

#include "users_distributor_impl.h"
#include "sharpei_client.h"
#include <ymod_mdb_sharder/shards_distributor.h>
#include <yplatform/find.h>

namespace ymod_mdb_sharder {

using shards_distributor_type = shards_distributor;
using users_distributor_type = users_distributor_impl<
    boost::shared_ptr<shards_distributor_type>,
    sharpei::client::SharpeiClientPtr>;

struct users_distributor::impl
{
    task_context_ptr ctx = boost::make_shared<yplatform::task_context>();
    std::shared_ptr<users_distributor_type> users_distributor;
};

users_distributor::users_distributor(boost::asio::io_service& io, const yplatform::ptree& conf)
{
    impl_ = std::make_shared<impl>();
    users_listener::settings users_polling_settings;
    users_polling_settings.get_changed_users_interval =
        conf.get<time_traits::duration>("users_polling.get_changed_users_interval");
    users_polling_settings.get_all_users_interval =
        conf.get<time_traits::duration>("users_polling.get_all_users_interval");
    auto shards_distributor = yplatform::find<shards_distributor_type>(
        conf.get<std::string>("shards_distributor_module"));
    auto sharpei_client = create_sharpei_client(impl_->ctx, conf.get_child("sharpei"));
    impl_->users_distributor = std::make_shared<users_distributor_type>(
        io, impl_->ctx, shards_distributor, sharpei_client, users_polling_settings);
    impl_->users_distributor->init();
}

void users_distributor::start()
{
    impl_->users_distributor->start();
}

void users_distributor::fini()
{
    impl_->users_distributor->fini();
}

void users_distributor::logger(const yplatform::log::source& source)
{
    contains_logger::logger(source);
    if (impl_->users_distributor)
    {
        impl_->users_distributor->logger(source);
    }
}

void users_distributor::subscribe(
    const shard_id_with_uids_cb& on_acquire_users,
    const shard_id_with_uids_cb& on_release_users)
{
    impl_->users_distributor->subscribe(on_acquire_users, on_release_users);
}

void users_distributor::get_owner(task_context_ptr context, uid_t uid, const node_info_cb& cb)
{
    impl_->users_distributor->get_owner(context, uid, cb);
}

void users_distributor::set_polling_methods(
    const get_all_users_method& get_all_users,
    const get_changed_users_method& get_changed_users)
{
    impl_->users_distributor->set_polling_methods(get_all_users, get_changed_users);
}

const std::string& users_distributor::my_node_id() const
{
    return impl_->users_distributor->my_node_id();
}

}