#pragma once

#include "errors.h"
#include "resolver.h"
#include "config.h"

#include <yplatform/zerocopy/segment.h>
#include <yplatform/module.h>
#include <yplatform/reactor.h>


namespace NMds {

std::string MakeStid(const std::string& uid, bool isShared);

class TClient : public yplatform::module {
public:
    void init(const yplatform::ptree& pt);
    void start();
    void stop();

    virtual void Put(
        TContext ctx,
        const std::string& id,
        const yplatform::zerocopy::segment& body,
        ENsType nsType,
        TGetPutCallback cb);

    virtual void Put(
        TContext ctx,
        const std::string& id,
        std::string body,
        ENsType nsType,
        TGetPutCallback cb);

    virtual void Check(TContext ctx, const std::string& stid, TCheckDelCallback cb);
    virtual void Del(TContext ctx, const std::string& stid, TCheckDelCallback cb);
    virtual void Get(TContext ctx, const std::string& stid, TGetPutCallback cb);

private:
    std::string GetHost() const;

private:
    TConfig Cfg;
    yplatform::reactor_ptr Reactor;
    THttpClientPtr HttpClient;
    std::shared_ptr<IHostResolver> HostResolver;
};

}  // namespace NMds
