#pragma once

#include "types.h"
#include "config.h"
#include "errors.h"

#include <yplatform/zerocopy/segment.h>

namespace NMds {

class TImpl
    : public std::enable_shared_from_this<TImpl>
    , public yplatform::log::contains_logger
{
public:
    TImpl(TContext ctx, TConfig cfg, THttpClientPtr httpClient);

    void Put(
        const std::string& host,
        const std::string& id,
        const yplatform::zerocopy::segment& body,
        ENsType nsType,
        TGetPutCallback cb);

    void Put(
        const std::string& host,
        const std::string& id,
        std::string body,
        ENsType nsType,
        TGetPutCallback cb);

    void Check(const std::string& stid, TCheckDelCallback cb);

    void Del(const std::string& stid, TCheckDelCallback cb);

    void Get(const std::string& stid, TGetPutCallback cb);

private:

    template <typename TCallback, typename TParam>
    void LogAndCallback(TCallback&& cb, TErrorCode ec, const TParam& param) {
        if (ec) {
            YLOG_L(error) << "mulcagate error: " << ec.message()
                << " '" << Cfg.Url << "'/'" << Cfg.Namespace << "'";
        }

        return cb(ec, param);
    }

    void OnPut(TGetPutCallback cb, TErrorCode ec, const yhttp::response& r);
    void OnGet(TGetPutCallback cb, TErrorCode ec, const yhttp::response& r);
    void OnCheckDel(TCheckDelCallback cb, TErrorCode ec, const yhttp::response& r);

private:
    TConfig Cfg;
    TContext Ctx;
    THttpClientPtr HttpClient;
};

}  // namespace NMds
