#include "config.h"

namespace NMds {

void TConfig::ParsePtree(const yplatform::ptree& conf) {
    HttpClientName = conf.get<std::string>("http_client_name");
    Url = conf.get<std::string>("url");
    RealPort = conf.get<size_t>("real_port");
    ServiceName = conf.get<std::string>("service_name");
    Namespace = conf.get<std::string>("namespace");
    NamespaceSpam = conf.get<std::string>("namespace_spam");
    NamespaceTmp = conf.get<std::string>("namespace_tmp");
    while (Url.back() == '/') {
        Url.pop_back();
    }

    const auto& pt = conf.get_child("host_resolver");
    Resolver.Use = pt.get<bool>("use", Resolver.Use);
    Resolver.Url = pt.get<std::string>("url");
    Resolver.Period = pt.get("period", Resolver.Period);

    const auto tvmConf = conf.get_child_optional("tvm");
    if (tvmConf) {
        Tvm.Use = tvmConf->get("use", Tvm.Use);
        Tvm.ModuleName = tvmConf->get("module_name", Tvm.ModuleName);
        if (Tvm.Use && Tvm.ModuleName.empty()) {
            throw std::logic_error("Empty module_name with enabled TVM");
        }
        Tvm.ServiceName = tvmConf->get("service_name", Tvm.ServiceName);
        if (Tvm.Use && Tvm.ServiceName.empty()) {
            throw std::logic_error("Empty service_name with enabled TVM");
        }
    }
}

}  // namespace NMds
