#pragma once

#include "types.h"
#include "config.h"

#include <boost/asio/io_service.hpp>

#include <string>

namespace NMds {

class IHostResolver {
public:
    virtual ~IHostResolver() = default;
    virtual void Start() = 0;
    virtual void Stop() = 0;
    virtual std::string GetRealHost() const = 0;
};

using THostResolverPtr = std::shared_ptr<IHostResolver>;

THostResolverPtr MakeHostResolver(
    boost::asio::io_service& io,
    TConfig::THostResolver config,
    THttpClientPtr httpClient);

} // namespace NMds
