#pragma once

#include <ymod_httpclient/call.h>

#include <yplatform/time_traits.h>
#include <yplatform/task_context.h>

#include <boost/system/error_code.hpp>

#include <functional>

namespace NMds {

enum ENsType {
    NS_MAIL = 1,
    NS_TMP,
    NS_SPAM
};

using TTimer = yplatform::time_traits::timer;
using TDuration = yplatform::time_traits::duration;
using TSeconds = yplatform::time_traits::seconds;
using TContext = yplatform::task_context_ptr;
using THttpClientPtr = std::shared_ptr<yhttp::simple_call>;

using TGetPutCallback = std::function<void(boost::system::error_code, const std::string&)>;
using TCheckDelCallback = std::function<void(boost::system::error_code, bool)>;

}  // namespace NMds
