#pragma once

#include <ymod_httpclient/call.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

struct THttpClientMock : yhttp::simple_call {
    using TTaskContextPtr = yhttp::simple_call::task_context_ptr;
    using TCallbackType = yhttp::simple_call::callback_type;
    MOCK_METHOD(yhttp::response, run, (TTaskContextPtr, yhttp::request), (override));
    MOCK_METHOD(yhttp::response, run, (TTaskContextPtr, yhttp::request, const yhttp::options&), (override));
    MOCK_METHOD(void, async_run, (TTaskContextPtr, yhttp::request, TCallbackType), (override));
    MOCK_METHOD(void, async_run, (TTaskContextPtr, yhttp::request, const yhttp::options&, TCallbackType), (override));
};

namespace ymod_httpclient {

// Used by EXPECT_CALL() arguments matchers
bool operator==(const request& lhs, const request& rhs) {
    if (std::tie(lhs.method, lhs.url, lhs.headers) == std::tie(rhs.method, rhs.url, rhs.headers)) {
        if (!lhs.body && !rhs.body) {
            return true;
        } else if (!lhs.body || !rhs.body) {
            return false;
        }

        return *lhs.body == *rhs.body;
    }

    return false;
}

std::ostream& operator<<(std::ostream& os, request::method_t meth) {
    switch (meth) {
        case request::method_t::GET:
            os << "GET";
            break;
        case request::method_t::HEAD:
            os << "HEAD";
            break;
        case request::method_t::POST:
            os << "POST";
            break;
        case request::method_t::PUT:
            os << "PUT";
            break;
        case request::method_t::DELETE:
            os << "DELETE";
            break;
    }
    return os;
}

std::ostream& operator<<(std::ostream& os, const request& req) {
    os << req.method << " " << req.url << ", headers: " << req.headers;
    return os;
}

} // namespace ymod_httpclient
