#pragma once

#include <ymod_messenger/buffers.h>
#include <ymod_messenger/detail/types.h>
#include <boost/asio/buffer.hpp>
#include <memory>

namespace ymod_messenger { namespace detail {

class fragment
{
public:
    typedef boost::asio::const_buffer value_type;
    typedef const boost::asio::const_buffer* const_iterator;

    fragment() : asio_buffer_(nullptr, 0)
    {
    }

    fragment(buffer buffer)
        : buffer_impl_(std::move(buffer)), asio_buffer_(buffer_impl_.data(), buffer_impl_.size())
    {
    }

    fragment(shared_buffer buffer)
        : shared_buffer_impl_(std::move(buffer))
        , asio_buffer_(shared_buffer_impl_.data(), shared_buffer_impl_.size())
    {
    }

    fragment(const fragment& other)
        : buffer_impl_(other.buffer_impl_), shared_buffer_impl_(other.shared_buffer_impl_)
    {
        if (buffer_impl_.size())
        {
            asio_buffer_ = boost::asio::buffer(buffer_impl_.data(), buffer_impl_.size());
        }
        else
        {
            asio_buffer_ =
                boost::asio::buffer(shared_buffer_impl_.data(), shared_buffer_impl_.size());
        }
    }

    fragment& operator=(const fragment& other)
    {
        if (this == &other)
        {
            buffer_impl_ = other.buffer_impl_;
            shared_buffer_impl_ = other.shared_buffer_impl_;
            if (buffer_impl_.size())
            {
                asio_buffer_ = boost::asio::buffer(buffer_impl_.data(), buffer_impl_.size());
            }
            else
            {
                asio_buffer_ =
                    boost::asio::buffer(shared_buffer_impl_.data(), shared_buffer_impl_.size());
            }
        }
        return *this;
    }

    fragment(fragment&& other) = default;

    fragment& operator=(fragment&& other) = default;

    const boost::asio::const_buffer* begin() const
    {
        return &asio_buffer_;
    }

    const boost::asio::const_buffer* end() const
    {
        return &asio_buffer_ + 1;
    }

    operator boost::asio::const_buffer() const
    {
        return asio_buffer_;
    }

    shared_buffer to_shared_buffer() const
    {
        if (buffer_impl_.size())
        {
            std::shared_ptr<char> tmp(new char[buffer_impl_.size()], std::default_delete<char[]>());
            std::copy(buffer_impl_.data(), buffer_impl_.data() + buffer_impl_.size(), tmp.get());
            return shared_buffer(tmp, buffer_impl_.size());
        }
        else
        {
            return shared_buffer_impl_;
        }
    }

    const char* data() const
    {
        return boost::asio::buffer_cast<const char*>(asio_buffer_);
    }

    size_t size() const
    {
        return boost::asio::buffer_size(asio_buffer_);
    }

private:
    buffer buffer_impl_;
    shared_buffer shared_buffer_impl_;
    boost::asio::const_buffer asio_buffer_;
};

} // detail
} // ymod_messenger
