#pragma once

#include <ymod_messenger/detail/types.h>
#include <yplatform/net/byte_order.h>
#include <cassert>
#include <cstring>
#include <memory>

namespace ymod_messenger { namespace detail {

/**
 * Header format:
 *   -------------------------------------------------
 *  | msg-type | flags | buffer-sz  | ... | buffer-sz |
 *   -------------------------------------------------
 *     32-bit    8-bit     32-bit     ...     32-bit
 *
 *  flags include buffers count.
 */

using flags_t = uint8_t;

constexpr size_t header_size(unsigned buffers_count)
{
    return sizeof(message_type) + sizeof(flags_t) + buffers_count * sizeof(uint32_t);
}

template <typename T>
inline size_t pack_numeric(T t, char* data)
{
    T encoded = yplatform::net::host_2_network(t);
    const char* pencoded = static_cast<char*>(static_cast<void*>(&encoded));
    memcpy(data, pencoded, sizeof(T));
    return sizeof(T);
}

inline size_t pack_flags(unsigned buffer_count, char* data)
{
    flags_t flags = static_cast<flags_t>(buffer_count - 1);
    return pack_numeric<flags_t>(flags, data);
}

inline size_t pack_header(
    message_type type,
    size_t buffer1_sz,
    char* data,
    [[maybe_unused]] size_t size)
{
    assert(header_size(1) <= size);
    size_t pos = 0;
    pos += pack_numeric<message_type>(type, data + pos);
    pos += pack_flags(1, data + pos);
    pos += pack_numeric<uint32_t>(static_cast<uint32_t>(buffer1_sz), data + pos);
    return pos;
}

inline size_t pack_header(
    message_type type,
    size_t buffer1_sz,
    size_t buffer2_sz,
    char* data,
    [[maybe_unused]] size_t size)
{
    assert(header_size(2) <= size);
    size_t pos = 0;
    pos += pack_numeric<message_type>(type, data + pos);
    pos += pack_flags(2, data + pos);
    pos += pack_numeric<uint32_t>(static_cast<uint32_t>(buffer1_sz), data + pos);
    pos += pack_numeric<uint32_t>(static_cast<uint32_t>(buffer2_sz), data + pos);
    return pos;
}

} // detail
} // ymod_messenger
