#pragma once

#include <ymod_messenger/types.h>
#include <msgpack/unpack.hpp>

namespace ymod_messenger { namespace detail {

/// Helps to invoke user handlers with concrete data types.
template <typename T, typename H>
struct message_handler_wrapper
{
public:
    message_handler_wrapper(H&& h) : h(std::forward<H>(h))
    {
    }

    /// Throws an exception if cast fails, ignores empty messages.
    void operator()(const address_t& address, const shared_buffers& seq)
    {
        try
        {
            if (seq.size())
            {
                auto& buffer = seq[0];
                msgpack::unpacked unpacked;
                msgpack::unpack(unpacked, buffer.data(), buffer.size());
                h(address, unpacked.get().as<T>());
            }
        }
        catch (...)
        {
        }
    }

private:
    typename std::decay<H>::type h;
};

} // detail
} // ymod_messenger
