#pragma once

#include <ymod_messenger/types.h>
#include <boost/lexical_cast.hpp>

namespace ymod_messenger {

struct host_info
{
    host_info() : port(0)
    {
    }
    host_info(const string& addr_, const unsigned port_) : addr(addr_), port(port_)
    {
    }

    string addr;
    unsigned port;

    operator string() const
    {
        return addr + ":" + boost::lexical_cast<string>(port);
    }

    string to_string() const
    {
        return this->operator string();
    }
};

bool operator<(const host_info& h1, const host_info& h2);
bool operator<=(const host_info& h1, const host_info& h2);
bool operator>(const host_info& h1, const host_info& h2);
bool operator>=(const host_info& h1, const host_info& h2);
bool operator==(const host_info& h1, const host_info& h2);
bool operator!=(const host_info& h1, const host_info& h2);
host_info make_host_info(const string& addr);

}
