#pragma once

#include <ymod_messenger/detail/segment.h>
#include <ymod_messenger/detail/types.h>
#include <ymod_messenger/buffers.h>
#include <string>
#include <boost/shared_ptr.hpp>
#include <boost/weak_ptr.hpp>
#include <boost/system/error_code.hpp>
#include <boost/function.hpp>
#include <yplatform/time_traits.h>
#include <yplatform/future/future.hpp>
#include <yplatform/net/types.h>
#include <msgpack.hpp>

namespace ymod_messenger {

using std::string;
using boost::shared_ptr;
using boost::weak_ptr;
using boost::make_shared;
using boost::enable_shared_from_this;
using boost::system::error_code;

namespace time_traits = yplatform::time_traits;

using yplatform::future::future;
using yplatform::future::promise;

typedef detail::address_t address_t;
typedef detail::message_type message_type;

// TODO not public interface types - hide
typedef boost::function<void(const address_t&, const shared_buffers&)> message_hook_t;
typedef detail::fragment fragment;
typedef detail::segment_t segment_t; // TODO rename

enum event_t
{
    event_CONNECTED,
    event_POOL_LOST
};

enum pool_type_t
{
    pool_INCOMING,
    pool_OUTGOING,
    pool_ANY
};

// WARNING changes here will break backward compartibility
enum base_message_type
{
    message_type_NONE = 0,
    message_type_USER = 1000
};

struct event_notification
{
    event_t event;
    pool_type_t pool;
};

typedef uint64_t hook_id_t;
typedef boost::function<void(const address_t&, const event_notification&)> event_hook_t;

}
