#include <ymod_messenger/host_info.h>

// TODO extract to yplatform

namespace ymod_messenger {

bool operator<(const host_info& h1, const host_info& h2)
{
    int r = h1.addr.compare(h2.addr);
    if (r < 0) return true;
    if (r == 0 && h1.port < h2.port) return true;
    return false;
}

bool operator<=(const host_info& h1, const host_info& h2)
{
    int r = h1.addr.compare(h2.addr);
    if (r < 0) return true;
    if (r == 0 && h1.port <= h2.port) return true;
    return false;
}

bool operator>(const host_info& h1, const host_info& h2)
{
    return !operator<=(h1, h2);
}

bool operator>=(const host_info& h1, const host_info& h2)
{
    return !operator<(h1, h2);
}

bool operator==(const host_info& h1, const host_info& h2)
{
    return h1.addr == h2.addr && h1.port == h2.port;
}

bool operator!=(const host_info& h1, const host_info& h2)
{
    return !operator==(h1, h2);
}

host_info make_host_info(const string& addr)
{
    host_info result;
    string::size_type del_pos = addr.find(':');
    if (del_pos == 0 || del_pos == string::npos)
        throw std::domain_error("invalid host format " + addr);
    result.addr = addr.substr(0, del_pos);
    try
    {
        result.port = boost::lexical_cast<unsigned>(addr.substr(del_pos + 1));
    }
    catch (std::exception& e)
    {
        throw std::domain_error("invalid host format " + addr + ": " + e.what());
    }
    return result;
}

}
