#include <ymod_messenger/module.h>

#include <yplatform/module_registration.h>
#include "impl.h"

namespace ymod_messenger {

module::module(yplatform::reactor& reactor, const yplatform::ptree& ptree)
    : impl_(std::make_shared<impl>())
{
    impl_->logger(*reactor.io());
    impl_->init(reactor, ptree);
}

module::module(boost::asio::io_service& io, const yplatform::ptree& ptree)
    : impl_(std::make_shared<impl>())
{
    auto reactor =
        boost::make_shared<yplatform::reactor>(std::make_shared<yplatform::io_pool>(io, 1));
    impl_->logger(io);
    impl_->init(*reactor, ptree);
}

void module::start()
{
    impl_->start();
}

void module::stop()
{
    impl_->stop();
}

void module::logger(const yplatform::log::source& logger)
{
    yplatform::module::logger(logger);
    impl_->logger(logger);
}

const address_t& module::my_address() const
{
    return impl_->my_address();
}

void module::connect(const string& address)
{
    impl_->connect(address);
}

void module::disconnect(const string& address)
{
    impl_->disconnect(address);
}

void module::connect_to_cluster(const std::set<address_t>& peers)
{
    impl_->connect_to_cluster(peers);
}

hook_id_t module::bind_messages(const message_hook_t& hook, const message_type type)
{
    return impl_->bind_messages(hook, type);
}

hook_id_t module::bind_events(const event_hook_t& hook)
{
    return impl_->bind_events(hook);
}

void module::do_send(const string& address, segment_t seg, const message_type type)
{
    impl_->do_send(address, seg, type);
}

void module::do_send_all(pool_type_t pool_type, segment_t seg, const message_type type)
{
    impl_->do_send_all(pool_type, seg, type);
}

const yplatform::module_stats_ptr module::get_module_stats() const
{
    return impl_->get_module_stats();
}

}

namespace {
DEFINE_SERVICE_OBJECT_BEGIN()
DEFINE_SERVICE_OBJECT_MODULE(ymod_messenger::module)
DEFINE_SERVICE_OBJECT_END()
}
