#include "pool_base.h"

using namespace ymod_messenger;

void pool_base::set_hooks(
    const session_open_hook_t& open_cb,
    const session_close_hook_t& close_cb,
    const message_hook_t& message_cb)
{
    lock_t lock(mutex_);
    if (detached_) return;
    hooks_.open = open_cb;
    hooks_.close = close_cb;
    hooks_.message = message_cb;
}

void pool_base::close()
{
    lock_t lock(mutex_);
    if (detached_) return;
    opened_ = false;
    items_t items_copy = items_;
    lock.unlock();
    for (items_t::iterator it = items_copy.begin(), end = items_copy.end(); it != end; ++it)
    {
        (*it)->async_close();
    }
}

void pool_base::detach()
{
    lock_t lock(mutex_);
    if (detached_) return;
    detached_ = true;
    hooks_.clear();
    items_t items_copy = items_;
    items_.clear();
    lock.unlock();
    for (items_t::iterator it = items_copy.begin(), end = items_copy.end(); it != end; ++it)
    {
        (*it)->async_close();
    }
}