#pragma once

#include <boost/function.hpp>
#include <yplatform/net/client_session_strand.h>
#include <yplatform/net/line_filter.h>
#include "session_base.h"
#include "../settings.h"

namespace ymod_messenger {

/**
 * Client session
 * extends base class by client session functions: connect, resolve
 */
class client_session
    : public session_base<yplatform::net::client_session_strand<client_settings>, client_settings>
{
    typedef session_base<yplatform::net::client_session_strand<settings_t>, settings_t> base_t;

public:
    typedef ymod_messenger::client_settings settings_t;

    client_session(yplatform::net::io_data* io_data, const settings_t& st) : base_t(io_data, st)
    {
    }

    using base_t::connect;
};

}
