#pragma once

#include <ymod_messenger/types.h>
#include <yplatform/net/buffer_sequence.h>

namespace ymod_messenger {

/// Queue with read and write parts to store
/// segments which are waiting for send via TCP connection
/// and segments which we are actually send now.
class segments_queue
{
public:
    typedef yplatform::net::zcopy_list<fragment> zcopy_list;

    void push(segment_t seg)
    {
        for (auto& fragment : seg)
        {
            waitq_.push_back(fragment);
        }
    }

    /// Swaps queues.
    size_t flush()
    {
        if (waitq_.empty()) return false;
        assert(sendq_.empty());
        std::swap(sendq_, waitq_);
        return true;
    }

    /// Consumes whole send queue after asio async_write with transfer_all condition.
    void consume([[maybe_unused]] size_t size)
    {
        assert(sendq_.size() == size);
        sendq_.clear();
    }

    const zcopy_list& wait_queue()
    {
        return waitq_;
    }

    const zcopy_list& send_queue()
    {
        return sendq_;
    }

    size_t size() const
    {
        return waitq_.size() + sendq_.size();
    }

private:
    zcopy_list waitq_;
    zcopy_list sendq_;
};

}
